/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.CorpusEditorShell;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.ConcordanceShell.CustomForegroundTableRenderer;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.gui.components.ColoredJButtonUI;
import net.nooj4nlp.gui.components.CustomJSpinner;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.AmbiguitiesUnambiguitiesDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ConcordanceShell;

public class AmbiguitiesUnambiguitiesActionListener
implements ActionListener {
    private boolean isButtonPressed;
    private TextEditorShellController textController;
    private AmbiguitiesUnambiguitiesDialog auDialog;
    private boolean areAmbiguities;

    public AmbiguitiesUnambiguitiesActionListener(TextEditorShellController textController, AmbiguitiesUnambiguitiesDialog ambiguitiesUnambigutiesDialog, boolean areAmbiguities, boolean buttonPressed) {
        this.isButtonPressed = buttonPressed;
        this.textController = textController;
        this.auDialog = ambiguitiesUnambigutiesDialog;
        this.areAmbiguities = areAmbiguities;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isButtonPressed) {
            ConcordanceShellController concordanceController;
            JTable ambigUnambigTable = this.auDialog.getTableAmbigUnambig();
            DefaultTableModel tableModel = (DefaultTableModel)ambigUnambigTable.getModel();
            int[] selectedItems = ambigUnambigTable.getSelectedRows();
            int selectedItemsLength = selectedItems.length;
            for (int k = 0; k < selectedItemsLength; ++k) {
                selectedItems[k] = ambigUnambigTable.convertRowIndexToModel(selectedItems[k]);
            }
            if (selectedItemsLength == 0) {
                return;
            }
            JButton button = (JButton)e.getSource();
            Color currentColor = ((ColoredJButtonUI)button.getUI()).getBackgroundColor();
            if (currentColor.equals(Color.GRAY)) {
                currentColor = Color.BLACK;
            }
            ArrayList<Object> seqOfAnnotations = new ArrayList<Object>();
            if (this.areAmbiguities) {
                ConcordanceShell concordanceShell;
                String analysis = this.auDialog.getComboPattern().getSelectedItem().toString();
                if (analysis.equals("") || analysis.charAt(0) != '<' || analysis.charAt(analysis.length() - 1) != '>') {
                    return;
                }
                this.textController.setListOfColors(null);
                this.textController.setAbsoluteBeginAddresses(null);
                this.textController.setAbsoluteEndAddresses(null);
                CustomJSpinner spinner = this.textController.getTextShell().getSpinner();
                spinner.setCustomValue(1);
                concordanceController = this.textController.getConcordanceController();
                if (concordanceController == null) {
                    concordanceShell = new ConcordanceShell(this.textController);
                    Launcher.getDesktopPane().add(concordanceShell);
                    concordanceShell.setVisible(true);
                } else {
                    concordanceShell = concordanceController.getConcordanceShell();
                    concordanceShell.getCustomForegroundTableRenderer().setSortedPreview(false);
                }
                concordanceController = concordanceShell.getController();
                CustomForegroundTableRenderer renderer = concordanceShell.getCustomForegroundTableRenderer();
                renderer.setSortedPreview(false);
                renderer.setColoredRowsMap(new HashMap<Integer, Color>());
                this.textController.setConcordanceController(concordanceController);
                concordanceController.setTheItems(new ArrayList<Object>());
                for (int i = 0; i < selectedItemsLength; ++i) {
                    ArrayList positions = (ArrayList)tableModel.getValueAt(selectedItems[i], 2);
                    for (int j = 0; j < positions.size(); j += 3) {
                        double absoluteBeginAddress = (Double)positions.get(j);
                        double absoluteEndAddress = (Double)positions.get(j + 1);
                        double tuNumb = Double.valueOf(positions.get(j + 2).toString());
                        int tuNb = (int)tuNumb;
                        seqOfAnnotations.add(tuNb);
                        seqOfAnnotations.add(analysis);
                        seqOfAnnotations.add(absoluteBeginAddress);
                        seqOfAnnotations.add(absoluteEndAddress);
                        seqOfAnnotations.add(absoluteBeginAddress);
                        seqOfAnnotations.add(analysis);
                        seqOfAnnotations.add(absoluteBeginAddress);
                        concordanceController.AddData(this.textController.getMyText(), "", currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, false, "Selected Tokens");
                    }
                }
            } else {
                ConcordanceShell concordanceShell;
                String analysis = tableModel.getValueAt(selectedItems[0], 1).toString();
                if (analysis.equals("") || analysis.charAt(0) != '<' || analysis.charAt(analysis.length() - 1) != '>') {
                    return;
                }
                ArrayList positions = (ArrayList)tableModel.getValueAt(selectedItems[0], 2);
                this.textController.setListOfColors(null);
                this.textController.setAbsoluteBeginAddresses(null);
                this.textController.setAbsoluteEndAddresses(null);
                CustomJSpinner spinner = this.textController.getTextShell().getSpinner();
                spinner.setCustomValue(1);
                concordanceController = this.textController.getConcordanceController();
                if (concordanceController == null) {
                    concordanceShell = new ConcordanceShell(this.textController);
                    Launcher.getDesktopPane().add(concordanceShell);
                    concordanceShell.setVisible(true);
                } else {
                    concordanceShell = concordanceController.getConcordanceShell();
                }
                concordanceController = concordanceShell.getController();
                CustomForegroundTableRenderer renderer = concordanceShell.getCustomForegroundTableRenderer();
                renderer.setSortedPreview(false);
                renderer.setColoredRowsMap(new HashMap<Integer, Color>());
                this.textController.setConcordanceController(concordanceController);
                concordanceController.setTheItems(new ArrayList<Object>());
                for (int j = 0; j < positions.size(); j += 3) {
                    double absoluteBeginAddress = (Double)positions.get(j);
                    double absoluteEndAddress = (Double)positions.get(j + 1);
                    double tuNumb = Double.valueOf(positions.get(j + 2).toString());
                    int tuNb = (int)tuNumb;
                    seqOfAnnotations.add(tuNb);
                    seqOfAnnotations.add(analysis);
                    seqOfAnnotations.add(absoluteBeginAddress);
                    seqOfAnnotations.add(absoluteEndAddress);
                    seqOfAnnotations.add(absoluteBeginAddress);
                    seqOfAnnotations.add(analysis);
                    seqOfAnnotations.add(absoluteBeginAddress);
                    concordanceController.AddData(this.textController.getMyText(), "", currentColor, tuNb, absoluteBeginAddress, absoluteEndAddress, seqOfAnnotations, false, "Selected Tokens");
                }
            }
            concordanceController.refreshConcordance();
            ambigUnambigTable.clearSelection();
        } else {
            AmbiguitiesUnambiguitiesActionListener.fillTheTable(this.textController, this.auDialog, this.areAmbiguities);
        }
    }

    private static String keepOnlyCategory(String ambig) {
        String[] tokensList = Dic.parseSequenceOfSymbols(ambig);
        StringBuilder result = new StringBuilder();
        for (String t : tokensList) {
            int tPos = t.indexOf(",");
            if (tPos == -1) {
                result.append(t);
                continue;
            }
            ++tPos;
            int i = 0;
            while (tPos + i < t.length() && Character.isUpperCase(t.charAt(tPos + i))) {
                ++i;
            }
            if (i == 0) {
                result.append(t);
                continue;
            }
            String cat = t.substring(tPos, tPos + i);
            result.append("<" + cat + "> ");
        }
        return result.toString();
    }

    public static void fillTheTable(TextEditorShellController textController, AmbiguitiesUnambiguitiesDialog auDialog, boolean areAmbiguities) {
        HashMap<Object, Object> hList = new HashMap();
        JTable tableAmbigUnambig = auDialog.getTableAmbigUnambig();
        DefaultTableModel tableModel = (DefaultTableModel)tableAmbigUnambig.getModel();
        tableModel.getDataVector().removeAllElements();
        tableModel.fireTableDataChanged();
        hList = areAmbiguities ? textController.getMyText().hAmbiguities : textController.getMyText().hUnambiguities;
        for (String string : hList.keySet()) {
            Object[] obj;
            ArrayList positions = (ArrayList)hList.get(string);
            int freq = positions.size() / 3;
            if (auDialog.getcBoxDisplayCategories().isSelected() && areAmbiguities) {
                obj = new Object[]{freq, AmbiguitiesUnambiguitiesActionListener.keepOnlyCategory(string), positions};
                tableModel.addRow(obj);
                continue;
            }
            obj = new Object[]{freq, string, positions};
            tableModel.addRow(obj);
        }
        tableAmbigUnambig.setModel(tableModel);
        AmbiguitiesUnambiguitiesActionListener.setWidthOfTableColumn(tableAmbigUnambig, tableModel, 0);
        AmbiguitiesUnambiguitiesActionListener.setWidthOfTableColumn(tableAmbigUnambig, tableModel, 1);
    }

    private static void setWidthOfTableColumn(JTable table, DefaultTableModel tableModel, int column) {
        int width = 0;
        for (int row = 0; row < tableModel.getRowCount(); ++row) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = table.prepareRenderer(renderer, row, column);
            width = Math.max(comp.getPreferredSize().width, width);
        }
        if (column == 0 && width < 50) {
            width = 50;
        } else if (column != 0 && width < 230) {
            width = 230;
        }
        table.getColumnModel().getColumn(column).setMaxWidth(width + 5);
        table.getColumnModel().getColumn(column).setPreferredWidth(width + 5);
    }
}

